/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.tests.dao;

import com.quantumdata.sct.dao.impl.StandardDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.StandardVO;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class StandardDAOTest
extends TestCase {
    private StandardDAO dao;
    private boolean bInitialize;

    public StandardDAOTest(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            System.setProperty(XMLDAOFactory.dataFileEnv, "." + System.getProperty("file.separator") + "Properties.props");
            this.dao = (StandardDAO)XMLDAOFactory.getStandardDAO();
            this.bInitialize = true;
        }
        catch (Exception exception) {
            this.bInitialize = false;
        }
    }

    public void flushTest() {
        boolean bl = false;
        StandardDAOTest.assertEquals(this.bInitialize, true);
        try {
            this.dao.flush();
        }
        catch (Exception exception) {
            bl = true;
        }
        StandardDAOTest.assertEquals(bl, false);
    }

    public void addTest() {
        boolean bl = false;
        StandardDAOTest.assertEquals(this.bInitialize, true);
        try {
            StandardVO standardVO = new StandardVO();
            standardVO.setId(this.dao.getUniqueKey());
            standardVO.set_name("TestName");
            standardVO.set_notation("test notation");
            standardVO.set_description("This is a test description");
            standardVO.set_version("1.0");
            standardVO.setDirty();
            System.out.println("Updating key = " + standardVO.getId());
            this.dao.add(standardVO);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        StandardDAOTest.assertEquals(bl, false);
    }

    public void deleteTest() {
        boolean bl = false;
        StandardDAOTest.assertEquals(this.bInitialize, true);
        try {
            IPersistable[] iPersistableArray = null;
            iPersistableArray = this.dao.findByAll();
            System.out.println("Find By All for delete");
            this.dao.remove(iPersistableArray[iPersistableArray.length - 1]);
            System.out.println("Deleting");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        StandardDAOTest.assertEquals(bl, false);
    }

    public void readAllTest() {
        boolean bl = false;
        StandardDAOTest.assertEquals(this.bInitialize, true);
        try {
            IPersistable[] iPersistableArray = this.dao.readAll();
            System.out.println(iPersistableArray.length);
            if (iPersistableArray.length > 0) {
                for (int i = 0; i < iPersistableArray.length; ++i) {
                    IPersistable iPersistable = iPersistableArray[i];
                    System.out.println(iPersistable.getId());
                }
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        StandardDAOTest.assertEquals(bl, false);
    }

    public void readTest() {
        boolean bl = false;
        StandardDAOTest.assertEquals(this.bInitialize, true);
        String string = "ID000010";
        try {
            IPersistable iPersistable = this.dao.read(string);
            bl = !iPersistable.getId().equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        StandardDAOTest.assertEquals(bl, false);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new StandardDAOTest("readTest"));
        testSuite.addTest(new StandardDAOTest("readAllTest"));
        testSuite.addTest(new StandardDAOTest("addTest"));
        testSuite.addTest(new StandardDAOTest("deleteTest"));
        testSuite.addTest(new StandardDAOTest("readAllTest"));
        testSuite.addTest(new StandardDAOTest("flushTest"));
        return testSuite;
    }
}

